<?php
// Automatically determine the site's URL
$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http'; // Check if HTTPS is enabled
$host = $_SERVER['HTTP_HOST']; // Get the domain name of the site
$site_url = $protocol . '://' . $host; // Create the full site URL

// Use DOCUMENT_ROOT to determine the folder paths
$document_root = $_SERVER['DOCUMENT_ROOT']; // Get the document root of the server

// Directories where files will be deleted and copied
$install_folder = $document_root . '/install'; // Path to the install folder
$psr_folder = $document_root . '/vendor/psr'; // Path to the psr folder

// Function to delete a file
function delete_file($file_path) {
    if (file_exists($file_path)) {
        unlink($file_path); // Delete the file
        echo "File deleted: " . $file_path . "<br>";
    } else {
        echo "File not found: " . $file_path . "<br>";
    }
}

// Function to copy a file
function copy_file($source, $destination) {
    if (file_exists($source)) {
        if (copy($source, $destination)) {
            echo "File copied from {$source} to {$destination}<br>";
        } else {
            echo "Failed to copy file from {$source} to {$destination}<br>";
        }
    } else {
        echo "Source file does not exist: {$source}<br>";
    }
}

// The file to be deleted
$file_to_delete = $install_folder . '/.lic'; // Path to the .lic file in the install folder

// Delete the file
delete_file($file_to_delete);

// The file to be copied (only install.licensebox)
$source_file1 = $psr_folder . '/install.licensebox'; // Source file in the psr folder
$destination_file1 = $install_folder . '/install.licensebox'; // Destination path in the install folder

// Copy the install.licensebox file
copy_file($source_file1, $destination_file1);

// Redirect to the site
header("Location: " . $site_url); // Automatically redirect to the site's URL
exit;
?>